#include <algorithm>
#include <iostream>
#include <vector>
#include <queue>
using namespace std;
#define fi first
#define se second
#define fr front()
#define pb push_back
typedef vector<vector<int>> vvi;
typedef vector<int> vi;
typedef pair<int, int> pii;

struct sol_ret
{
    int max_diam;
    pii max_edge_removed;
    pii max_edge_added;
};

pair<int,int> __most_distant(int u, const vvi& tree, vector<bool>& visited)
{
    visited[u] = 1;
    int max_dist = 0;
    int max_node = u;
    for (int neighbor: tree[u])
    {
        if (!visited[neighbor])
        {
            auto p = __most_distant(neighbor, tree, visited);
            int dist = p.fi + 1;
            int node = p.se;
            if (dist > max_dist)
            {
				max_dist = dist;
				max_node = node;
			}
		}
    }
    return { max_dist, max_node };
}

int most_distant(int u, const vvi& tree)
{
	vector<bool> visited(tree.size(), 0);
	return __most_distant(u, tree, visited).se;
}

bool __get_path(int node, int end,const vvi& tree,  vi& curr_path, vector<bool>& visited)
{
    curr_path.push_back(node);
    visited[node] = 1;
    if (node == end)
        return true;
    
    for (int neighbor: tree[node])
    {
        if (!visited[neighbor])
        {
            if (__get_path(neighbor, end, tree, curr_path, visited))
                return true;
        }
    }
    curr_path.pop_back();
    return false;
}

vi get_path(int start, int end, const vvi& tree)
{
    vector<int> path;
    vector<bool> visited(tree.size(), 0);
    __get_path(start, end, tree, path, visited);
    return path;
}

vi nodes_on_diam(const vvi& tree) 
{
    int u = most_distant(0, tree);
    int v = most_distant(u, tree);
    return get_path(u, v, tree);
}

int max_dist(int parent, int u, const vvi& tree)
{
    int d = 0;
    for (int neighbor : tree[u])
        if (neighbor != parent)
            d = max(d, max_dist(u, neighbor, tree) + 1);
    return d;
}

int max_dist_no_diam(const vvi& tree, const vector<bool>& on_diameter, vi& tmp, int x) 
{
    queue<int> bfs_queue;
    int max_dist_node = x;
    bfs_queue.push(x);
    tmp[x] = 0;
    while (bfs_queue.size()) {
        int next = bfs_queue.front();
        bfs_queue.pop();
        for (int i : tree[next]) {
            if (tmp[i] == -1 && !on_diameter[i]) {
                tmp[i] = tmp[next] + 1;
                if (tmp[i] > tmp[max_dist_node]) {
                    max_dist_node = i;
                }
                bfs_queue.push(i);
            }
        }
    }
    return max_dist_node;
}

sol_ret solve(const vvi& tree)
{
    int n = tree.size();
    auto diameter = nodes_on_diam(tree);
    if (diameter.size() == n)
    {
        return { n - 1, { -1,-1 }, {-1,-1 } };
    }

    vector<bool> is_on_diameter(n);
    for (int node : diameter)
        is_on_diameter[node] = 1;

    vector<int> longest_path(n);
    for (int node : diameter)
    {
        int max_d = 0;
        for (int neighbor : tree[node])
            if (!is_on_diameter[neighbor])
                max_d = max(max_d, max_dist(node, neighbor, tree) + 1);
        longest_path[node] = max_d;
    }

    int d = diameter.size();
    vi path_len_left(d);
    for (int i = 0; i < d; i++)
    {
        int node = diameter[i];
        int dist_end = i;
        int farthest_from_node = longest_path[node];
        path_len_left[i] = dist_end + farthest_from_node;
    }

    vi path_len_right(d);
    for (int i = d - 1; i >= 0; i--)
    {
        int node = diameter[i];
        int dist_end = d - i - 1;
        int farthest_from_node = longest_path[node];
        path_len_right[i] = dist_end + farthest_from_node;
    }

    vi max_left(d);
    max_left[0] = path_len_left[0];
    for (int i = 1; i < d; i++)
        max_left[i] = max(max_left[i - 1], path_len_left[i]);

    vi max_right(d);
    max_right[d - 1] = path_len_right[d - 1];
    for (int i = d - 2; i >= 0; i--)
        max_right[i] = max(max_right[i + 1], path_len_right[i]);

    int max_diam = 0;
    pii max_edge_removed = { -1, -1 };
    pii max_edge_added = { -1, -1 };
    for (int i = 0; i < d - 1; i++)
    {
        if (max_left[i] + max_right[i + 1] + 1 >= max_diam)
        {
            max_edge_removed = { diameter[i], diameter[i + 1] };
            max_edge_added = { diameter[0], diameter[d - 1] };
            max_diam = max_left[i] + max_right[i + 1] + 1;
        }
    }

    vi tmp(n, -1);
    vi furthest_node;
    vector<pii> removed_edge;
    for (int node : diameter) {
        for (int neighbor : tree[node]) {
            if (!is_on_diameter[neighbor]) {
                furthest_node.push_back(max_dist_no_diam(tree, is_on_diameter, tmp, neighbor));
                removed_edge.push_back({ node,neighbor });
            }
        }
    }
    tmp = vi(n, -1);
    for (int i = 0; i < furthest_node.size(); i++)
    {
        int node = furthest_node[i];
        int furthest_node = max_dist_no_diam(tree, is_on_diameter, tmp, node);
        int len = d + tmp[furthest_node];
        auto e = removed_edge[i];
        if (len >= max_diam)
        {
            max_diam = len;
            max_edge_removed = removed_edge[i];
            max_edge_added = { diameter[0], furthest_node};
        }
    }
    return { max_diam, max_edge_removed, max_edge_added };
}

void rebuild_tree(vvi& tree, pii removed_edge, pii added_edge)
{
    int u = removed_edge.fi;
    int v = removed_edge.se;
    tree[u].erase(find(tree[u].begin(),tree[u].end(),v));
    tree[v].erase(find(tree[v].begin(), tree[v].end(), u));

    u = added_edge.fi;
    v = added_edge.se;
    tree[u].push_back(v);
    tree[v].push_back(u);
}

int main()
{
    ios::sync_with_stdio(false);
    cin.tie(0);

    int test_cnt; cin >> test_cnt;
    while (test_cnt--)
    {
        int n, k; cin >> n >> k;
        vvi tree(n);
        for (int i = 0; i < n - 1; i++) {
            int u, v; cin >> u >> v;
            u--; v--;
            tree[u].push_back(v);
            tree[v].push_back(u);
        }
        bool done = false;

        for (int i = 0; i < k; i++)
        {
            auto sol = solve(tree);
            if (sol.max_edge_added.fi == -1 || i == k-1)
            {
                cout << sol.max_diam << endl;
                done = 1;
                break;
            }
            rebuild_tree(tree, sol.max_edge_removed, sol.max_edge_added);
        }
        if (done)
        {
            continue;
        }
        cout << nodes_on_diam(tree).size() - 1 << endl;
    }
    return 0;
}